#include <bits/stdc++.h>

using namespace std;

using ll = long long int;

enum token_type : char {
    NUMBER = '8',
    ADD = '+',
    MUL = '*',
};

struct token {
    token_type type;
    ll val;
};

static token next_tkn(const string& str, string::const_iterator& it);

int main() {
    string str; cin >> str;
    bool is_m = false;
    ll m_val = 0,p_val = 0;

    auto it = str.cbegin();
    do {
        auto tkn = next_tkn(str, it);

        if(tkn.type == ADD){
            is_m = false;
            p_val += m_val;
        } else if(tkn.type == NUMBER){
            if(!is_m){
                is_m = true;
                m_val = tkn.val;
            } else
                m_val *= tkn.val;
        }
    } while(it != str.cend());

    if(is_m)
        p_val += m_val;

    cout << p_val;

    return 0;
}

static token next_tkn(const string& str, string::const_iterator& it){
    if(isdigit(*it)){
        ll val = 0;
        while(it != str.cend() && isdigit(*it)){
            val = val*10+(*it-'0');
            it++;
        }
        return {NUMBER, val};
    } else if(*it == '+'){
        it++;
        return {ADD, 0};
    }
    else if(*it == '*') {
        it++;
        return {MUL, 0};
    }
    else
        exit(EXIT_FAILURE);
}